
<?php
header('Content-Type: application/json');
require_once 'db_connect.php';

$action = isset($_POST['action']) ? $_POST['action'] : (isset($_GET['action']) ? $_GET['action'] : '');
$response = ['status' => 'error', 'message' => 'Invalid Action'];

// ============================================
// 1. REGISTER
// ============================================
if ($action == 'register') {
    $phone = $conn->real_escape_string($_POST['phone']);
    $username = $conn->real_escape_string($_POST['username']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $invite_code = $_POST['invite_code'] ?? null;
    $u_id = rand(100000, 999999);

    $check = $conn->query("SELECT id FROM users WHERE phone = '$phone'");
    if ($check->num_rows > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Phone already exists!']);
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO users (username, phone, password, u_id, referrer_u_id) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $username, $phone, $password, $u_id, $invite_code);
    
    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Registration successful!']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Database error']);
    }
    exit;
}

// ============================================
// 2. LOGIN
// ============================================
if ($action == 'login') {
    $phone = $conn->real_escape_string($_POST['phone']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, password FROM users WHERE phone = ?");
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            echo json_encode(['status' => 'success', 'message' => 'Login successful!', 'redirect' => 'index.php']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Wrong Password!']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'User not found!']);
    }
    exit;
}

// ============================================
// 3. GET GAME INFO (Timer & Period Logic)
// ============================================
if ($action == 'get_game_info') {
    $game_type = $_GET['type'] ?? 'wingo30s';
    
    // Duration Logic
    $duration = 30;
    if($game_type == 'wingo1m') $duration = 60;
    if($game_type == 'wingo3m') $duration = 180;
    if($game_type == 'wingo5m') $duration = 300;

    $time = time();
    $current_period_num = floor($time / $duration);
    $seconds_remaining = $duration - ($time % $duration);
    $date_part = date("Ymd");
    $full_period = $date_part . $current_period_num;

    // *** IMPORTANT: Check Previous Period & Settle Bets ***
    // This logic ensures if the time passed, the result is declared.
    $prev_period_num = $current_period_num - 1;
    $prev_full_period = $date_part . $prev_period_num;
    
    // Check if result exists for previous period, if not, create it
    checkAndGenerateResult($conn, $game_type, $prev_full_period);

    echo json_encode([
        'status' => 'success',
        'period' => $full_period,
        'remaining_seconds' => $seconds_remaining
    ]);
    exit;
}

// ============================================
// 4. PLACE BET
// ============================================
if ($action == 'place_bet') {
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'Please login first!']);
        exit;
    }

    $user_id = $_SESSION['user_id'];
    $game_type = $_POST['game_type'];
    $selection = $_POST['selection'];
    $amount = (float)$_POST['amount'];
    
    // Get Current Period
    $duration = 30;
    if($game_type == 'wingo1m') $duration = 60;
    if($game_type == 'wingo3m') $duration = 180;
    if($game_type == 'wingo5m') $duration = 300;
    
    $time = time();
    $seconds_remaining = $duration - ($time % $duration);

    // Stop betting last 5 seconds
    if ($seconds_remaining <= 5) {
        echo json_encode(['status' => 'error', 'message' => 'Betting closed for this period!']);
        exit;
    }

    $current_period = date("Ymd") . floor($time / $duration);

    // Check Balance
    $user = $conn->query("SELECT balance FROM users WHERE id = '$user_id'")->fetch_assoc();
    if ($user['balance'] >= $amount) {
        $new_bal = $user['balance'] - $amount;
        $conn->query("UPDATE users SET balance = '$new_bal' WHERE id = '$user_id'");
        
        $stmt = $conn->prepare("INSERT INTO bets (user_id, game_type, period, selection, amount, status) VALUES (?, ?, ?, ?, ?, 'pending')");
        $stmt->bind_param("isssd", $user_id, $game_type, $current_period, $selection, $amount);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Bet placed!', 'new_balance' => $new_bal]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Insufficient Balance!']);
    }
    exit;
}

// ============================================
// 5. GAME HISTORY (Public)
// ============================================
if ($action == 'game_history') {
    $type = $_GET['type'] ?? 'wingo30s';
    $sql = "SELECT * FROM game_results WHERE game_type='$type' ORDER BY period DESC LIMIT 10";
    $result = $conn->query($sql);
    $data = [];
    while($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode(['status' => 'success', 'data' => $data]);
    exit;
}

// ============================================
// HELPER FUNCTION: RESULT GENERATION & PAYOUT
// ============================================
function checkAndGenerateResult($conn, $type, $period) {
    // 1. Check if result already exists
    $check = $conn->query("SELECT id FROM game_results WHERE game_type='$type' AND period='$period'");
    if ($check->num_rows > 0) {
        return; // Result already exists, do nothing
    }

    // 2. If not, Generate Random Result
    // Logic: 0-9 Number. 
    // Colors: 1,3,7,9 Green | 2,4,6,8 Red | 0,5 Violet+Red/Green
    // Size: 0-4 Small | 5-9 Big
    
    $number = rand(0, 9);
    $size = ($number >= 5) ? 'Big' : 'Small';
    $color = ($number == 0 || $number == 5) ? 'Violet' : (($number % 2 == 0) ? 'Red' : 'Green');

    // Save Result
    $stmt = $conn->prepare("INSERT INTO game_results (game_type, period, result_number, result_color, result_size) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("ssiss", $type, $period, $number, $color, $size);
    $stmt->execute();

    // 3. PAYOUT LOGIC (Process Bets)
    $bets = $conn->query("SELECT * FROM bets WHERE game_type='$type' AND period='$period' AND status='pending'");
    
    while ($bet = $bets->fetch_assoc()) {
        $win = false;
        $payout = 0;
        $select = $bet['selection'];
        $amount = $bet['amount'];

        // Win Logic
        // Number Match
        if (is_numeric($select) && $select == $number) {
            $win = true; 
            $payout = $amount * 9; 
        }
        // Size Match
        elseif ($select == $size) {
            $win = true;
            $payout = $amount * 1.96;
        }
        // Color Match (Simplified)
        elseif ($select == 'Green' && ($number == 1 || $number == 3 || $number == 7 || $number == 9)) {
            $win = true; $payout = $amount * 1.96;
        }
        elseif ($select == 'Red' && ($number == 2 || $number == 4 || $number == 6 || $number == 8)) {
            $win = true; $payout = $amount * 1.96;
        }
        elseif ($select == 'Violet' && ($number == 0 || $number == 5)) {
            $win = true; $payout = $amount * 4.5;
        }
        // Special case for Green on 5 and Red on 0 (1.5x) - You can add if needed

        // Update Bet & Balance
        $status = $win ? 'win' : 'loss';
        $conn->query("UPDATE bets SET status='$status', win_amount='$payout' WHERE id='{$bet['id']}'");
        
        if ($win) {
            $conn->query("UPDATE users SET balance = balance + $payout WHERE id='{$bet['user_id']}'");
        }
    }
}
?>
